#target illustrator

// Outlines Font Fix (c) 2025
// Replaces all HelveticaNeueCyr* fonts with Arial in the active document.

(function () {

    if (app.documents.length === 0) {
        alert("No documents are open.\nPlease open an AI/EPS/PDF file containing live text and run the script again.");
        return;
    }

    var doc = app.activeDocument;

    // Locate Arial font (common PostScript name: ArialMT)
    var arialFont = null;
    try {
        arialFont = app.textFonts.getByName("ArialMT");
    } catch (e1) {
        try {
            arialFont = app.textFonts.getByName("Arial");
        } catch (e2) {
            alert("Arial font not found.\nArial is not available in your system.");
            return;
        }
    }

    // Regex to match all HelveticaNeueCyr variants
    // including subset fonts like ABCDE+HelveticaNeueCyr
    var helvRegex = /HelveticaNeueCyr/i;

    var totalCharsPatched = 0;
    var totalTextFramesTouched = 0;

    var tfCount = doc.textFrames.length;

    // Iterate through all text frames
    for (var i = 0; i < tfCount; i++) {
        var tf = doc.textFrames[i];
        var tr = tf.textRange;
        var chars = tr.characters;
        var localPatched = 0;

        for (var c = 0; c < chars.length; c++) {
            var ch = chars[c];
            var attr = ch.characterAttributes;
            var fnt = attr.textFont;

            if (!fnt) continue;

            // Collect all possible font identifiers
            var namesToCheck = [];

            try { namesToCheck.push(fnt.name); } catch (e) {}
            try { namesToCheck.push(fnt.family); } catch (e) {}
            try { namesToCheck.push(fnt.fullName); } catch (e) {}
            try { namesToCheck.push(fnt.postScriptName); } catch (e) {}

            var matchFound = false;

            for (var n = 0; n < namesToCheck.length; n++) {
                var nm = namesToCheck[n];
                if (nm && helvRegex.test(nm)) {
                    matchFound = true;
                    break;
                }
            }

            if (matchFound) {
                attr.textFont = arialFont;
                localPatched++;
            }
        }

        if (localPatched > 0) {
            totalCharsPatched += localPatched;
            totalTextFramesTouched++;
        }
    }

    if (totalCharsPatched === 0) {
        alert(
            "No matching fonts found.\n" +
            "No HelveticaNeueCyr variations were detected in this document."
        );
    } else {
        alert(
      "Outlines Font Patch (c) 2025\n\n" +
"Success!\n" +
"Text frames updated: " + totalTextFramesTouched + "\n" +
"Characters updated: " + totalCharsPatched + "\n\n" +
"All missing fonts have been replaced with Arial.\n" +
"Press OK to continue."
        );
    }

})();
